/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class Encoder {
    private static int[] crcTable = null;

    private Encoder() {
    }

    public static Image toImage(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) {
        try {
            byte[] png = Encoder.toPNG(width, height, alpha, red, green, blue);
            return Image.createImage((byte[])png, (int)0, (int)png.length);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Image toImage(byte[] png) {
        try {
            return Image.createImage((byte[])png, (int)0, (int)png.length);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] toPNG(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] header = Encoder.createHeaderChunk(width, height);
        byte[] data = Encoder.createDataChunk(width, height, alpha, red, green, blue);
        byte[] trailer = Encoder.createTrailerChunk();
        ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
        png.write(signature);
        png.write(header);
        png.write(data);
        png.write(trailer);
        return png.toByteArray();
    }

    public static byte[] toPNG(Image image) {
        try {
            int imageSize = image.getWidth() * image.getHeight();
            int[] rgbs = new int[imageSize];
            image.getRGB(rgbs, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
            byte[] a = new byte[imageSize];
            byte[] r = new byte[imageSize];
            byte[] g = new byte[imageSize];
            byte[] b = new byte[imageSize];
            for (int i = 0; i < imageSize; ++i) {
                int colorToDecode = rgbs[i];
                a[i] = (byte)((colorToDecode & 0xFF000000) >>> 24);
                r[i] = (byte)((colorToDecode & 0xFF0000) >>> 16);
                g[i] = (byte)((colorToDecode & 0xFF00) >>> 8);
                b[i] = (byte)(colorToDecode & 0xFF);
            }
            return Encoder.toPNG(image.getWidth(), image.getHeight(), a, r, g, b);
        }
        catch (IOException exception) {
            return null;
        }
    }

    private static byte[] createHeaderChunk(int width, int height) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(width);
        chunk.writeInt(height);
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        return Encoder.toChunk("IHDR", baos.toByteArray());
    }

    private static byte[] createDataChunk(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        int source = 0;
        int dest = 0;
        byte[] raw = new byte[4 * (width * height) + height];
        for (int y = 0; y < height; ++y) {
            raw[dest++] = 0;
            for (int x = 0; x < width; ++x) {
                raw[dest++] = red[source];
                raw[dest++] = green[source];
                raw[dest++] = blue[source];
                raw[dest++] = alpha[source++];
            }
        }
        return Encoder.toChunk("IDAT", Encoder.toZLIB(raw));
    }

    private static byte[] createTrailerChunk() throws IOException {
        return Encoder.toChunk("IEND", new byte[0]);
    }

    private static byte[] toChunk(String id, byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(raw.length);
        byte[] bid = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bid[i] = (byte)id.charAt(i);
        }
        chunk.write(bid);
        chunk.write(raw);
        int crc = -1;
        crc = Encoder.updateCRC(crc, bid);
        crc = Encoder.updateCRC(crc, raw);
        chunk.writeInt(~crc);
        return baos.toByteArray();
    }

    private static void createCRCTable() {
        crcTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int k = 0; k < 8; ++k) {
                c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            Encoder.crcTable[i] = c;
        }
    }

    private static int updateCRC(int crc, byte[] raw) {
        if (crcTable == null) {
            Encoder.createCRCTable();
        }
        for (int i = 0; i < raw.length; ++i) {
            crc = crcTable[(crc ^ raw[i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    private static byte[] toZLIB(byte[] raw) throws IOException {
        ZStream jStream;
        byte[] bBuffer;
        int iStatus;
        block4: {
            iStatus = 0;
            bBuffer = new byte[raw.length];
            jStream = new ZStream();
            iStatus = jStream.deflateInit(9);
            if (iStatus != 0) {
                throw new IOException("Failure in deflateInit(JZlib.Z_BEST_COMPRESSION)");
            }
            jStream.next_in = raw;
            jStream.next_in_index = 0;
            jStream.next_out = bBuffer;
            jStream.next_out_index = 0;
            while (jStream.total_in != (long)raw.length && jStream.total_out < (long)bBuffer.length) {
                jStream.avail_out = 1;
                jStream.avail_in = 1;
                iStatus = jStream.deflate(0);
                if (iStatus == 0) continue;
                throw new IOException("Failure in deflate(JZlib.Z_NO_FLUSH)");
            }
            do {
                jStream.avail_out = 1;
                iStatus = jStream.deflate(4);
                if (iStatus == 1) break block4;
            } while (iStatus == 0);
            throw new IOException("Failure in deflate(JZlib.Z_FINISH)");
        }
        iStatus = jStream.deflateEnd();
        if (iStatus != 0) {
            throw new IOException("Failure in deflateEnd()");
        }
        byte[] bReturn = new byte[(int)jStream.total_out];
        System.arraycopy(bBuffer, 0, bReturn, 0, (int)jStream.total_out);
        return bReturn;
    }
}

