/*
 * Decompiled with CFR 0.152.
 */
package CP.Game;

import CP.Blocks.Blocks;
import CP.CPJrts.CPJrts;
import CP.Canvas.Canvas;
import CP.Config.Config;
import CP.DefaultBlocks.DefaultBlocks;
import CP.DefaultMobs.DefaultMobs;
import CP.DefaultWidgets.DefaultWidgets;
import CP.Drop.Drop;
import CP.GUI.GUI;
import CP.Game.Proc$Lit$14;
import CP.Game.Proc$Lit$15;
import CP.InventoryFast.InventoryFast;
import CP.InventoryWindow.InventoryWindow;
import CP.Item.Item;
import CP.Item.Item_Item;
import CP.Keyboard.Keyboard;
import CP.Log.Log;
import CP.Map.Map;
import CP.Mobs.Mobs;
import CP.Player.Player;
import CP.String.String;
import CP.System.System;
import CP.Text.Text;
import CP.Windows.Windows;
import javax.microedition.lcdui.Image;

public final class Game {
    static int curx;
    static int cury;
    static boolean editmode;
    static Image editcursor;
    static Image[] fastinv;

    static void DrawDebugInfo() {
        Canvas.SetColor(255, 255, 255);
        java.lang.String string = String.IntToString(Canvas.GetFps());
        int n = 0;
        Text.Draw(string, 0, n);
        string = String.RealToString(Player.GetX());
        Text.Draw(string, 0, n += Text.Height(string));
        string = String.RealToString(Player.GetY());
        Text.Draw(string, 0, n += Text.Height(string));
        string = String.IntToString(Config.tileSize);
        Text.Draw(string, 0, n += Text.Height(string));
        string = System.m.getAppProperty("System-Init");
        if (CPJrts.JavaStrToChrOpen(string) == null) {
            string = "(nil)";
        }
        Text.Draw(string, 0, n += Text.Height(string));
        string = String.IntToString(String.Length(string));
        if (CPJrts.JavaStrToChrOpen(string) == null) {
            string = "-1";
        }
        Text.Draw(string, 0, n += Text.Height(string));
    }

    static void DrawGame() {
        int n = (int)Math.floor(Player.GetX() * (double)Config.tileSize) - (Canvas.Width() >> 1);
        int n2 = (int)Math.floor(Player.GetY() * (double)Config.tileSize) - (Canvas.Height() >> 1);
        int[] nArray = new int[1];
        n = Map.BlockCamera(n, n2, nArray);
        n2 = nArray[0];
        Canvas.SetColor(0, 0, 127);
        Canvas.FillRect(0, 0, Canvas.Width(), Canvas.Height());
        Map.DrawMap(n, n2);
        Mobs.Draw(n, n2);
        Drop.Draw(n, n2);
        if (editmode) {
            CP.Image.Image.Draw(editcursor, curx * Config.tileSize - n, cury * Config.tileSize - n2);
        }
        InventoryFast.UpdateWidgets();
        GUI.DrawTiles(fastinv, Windows.X(), Windows.Y(), Windows.W(), Windows.H());
        Windows.DrawWidgets();
        Game.DrawDebugInfo();
    }

    static void Std_KeyHandler() {
        if (Keyboard.KeyPressed(-1) || Keyboard.KeyPressed(50)) {
            Player.GoUp();
        }
        if (Keyboard.KeyPressed(-2) || Keyboard.KeyPressed(56)) {
            Player.GoDown();
        }
        if (Keyboard.KeyPressed(-3) || Keyboard.KeyPressed(52)) {
            Player.GoLeft();
        }
        if (Keyboard.KeyPressed(-4) || Keyboard.KeyPressed(54)) {
            Player.GoRight();
        }
        if (Keyboard.KeyClicked(-5) || Keyboard.KeyClicked(53)) {
            Mobs.Create("PLAYER", Player.GetX(), Player.GetY());
        }
        if (Keyboard.KeyClicked(49)) {
            InventoryWindow.Open(Player.GetInv());
        }
        if (Keyboard.KeyClicked(51)) {
            Item_Item[] item_ItemArray = Player.GetInv().items;
            item_ItemArray[InventoryFast.focus] = Item.Use(Player.GetInv().items[InventoryFast.focus], (int)Math.floor(Player.GetX()), (int)Math.floor(Player.GetY()));
        }
        if (Keyboard.KeyClicked(57)) {
            System.Exit();
        }
        if (Keyboard.KeyClicked(48)) {
            editmode = true;
            curx = (int)Math.floor(Player.GetX());
            cury = (int)Math.floor(Player.GetY());
        }
        if (Keyboard.KeyClicked(35)) {
            InventoryFast.Right();
        }
        if (Keyboard.KeyClicked(42)) {
            InventoryFast.Left();
        }
    }

    static void Edit_KeyHandler() {
        if (Keyboard.KeyClicked(-1) || Keyboard.KeyClicked(50)) {
            --cury;
        }
        if (Keyboard.KeyClicked(-2) || Keyboard.KeyClicked(56)) {
            ++cury;
        }
        if (Keyboard.KeyClicked(-3) || Keyboard.KeyClicked(52)) {
            --curx;
        }
        if (Keyboard.KeyClicked(-4) || Keyboard.KeyClicked(54)) {
            ++curx;
        }
        if (Keyboard.KeyClicked(-5) || Keyboard.KeyClicked(53)) {
            Blocks.InfoList[Map.Get(curx, cury)].Destroy(curx, cury);
        }
        if (Keyboard.KeyClicked(51)) {
            Item_Item[] item_ItemArray = Player.GetInv().items;
            item_ItemArray[InventoryFast.focus] = Item.Use(Player.GetInv().items[InventoryFast.focus], curx, cury);
        }
        if (Keyboard.KeyClicked(57)) {
            System.Exit();
        }
        if (Keyboard.KeyClicked(48)) {
            editmode = false;
        }
        if (Keyboard.KeyClicked(35)) {
            InventoryFast.Right();
        }
        if (Keyboard.KeyClicked(42)) {
            InventoryFast.Left();
        }
    }

    static boolean GrabKeyboard() {
        if (editmode) {
            Game.Edit_KeyHandler();
        } else {
            Game.Std_KeyHandler();
        }
        return true;
    }

    static int SpawPoint(int n) {
        int n2 = 0;
        if (Map.Get(n, n2) == 0) {
            while (Map.Get(n, ++n2) == 0) {
            }
        }
        return n2 - 1;
    }

    static void Loop() {
        Player.Do();
        Mobs.DoAi();
        Mobs.DoPhysics();
        Drop.DoPhysics();
        Game.DrawGame();
    }

    public static void Init() {
        Log.PrintLn("Init Game...");
        editcursor = CP.Image.Image.Resize(CP.Image.Image.Load("/RESOURCE/cursor.png"), Config.tileSize, Config.tileSize);
        fastinv = GUI.LoadTiles("/RESOURCE/fastinv.png");
        Text.Init();
        GUI.Init();
        DefaultWidgets.Init();
        DefaultMobs.Init();
        DefaultBlocks.Init();
    }

    public static void Start() {
        Game.Init();
        Player.SetController(Mobs.CreateRET("PLAYER", 0.0, Game.SpawPoint(0)));
        Windows.Begin(new Proc$Lit$14(), new Proc$Lit$15(), null);
        Windows.End();
    }
}

